/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (09/05/07)
 */    
package com.ejie.p06b.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.log.P06BLog;



public class P06BParametros {

    
    public Properties getParametros() throws IOException {
        Properties par=null;
    
        par=new Properties();
        InputStream in=getClass().getResourceAsStream(P06BConstantes.P06B_PROPERTIES_DEFAULT);
        par.load(in);
        in.close();

        return(par);
    }

    public Properties getParametros(String path) throws IOException {
        Properties par=null;
    
        par=new Properties();
        InputStream in=getClass().getResourceAsStream(path);
        par.load(in);
        in.close();

        return(par);
    }
    
    /**
     *  Obtiene la caracterstica astrClave de la configuracin.
     *  @param  astrClave   caracterstica que queremos obtener.
     *  @return String      valor que tiene la caracterstica buscada.
     */    
    public static String get(String astrClave) {
        String lstrValor = "";
            
        P06BParametros utiles=new P06BParametros();
    	Properties p1;
		try {
			p1 = utiles.getParametros(P06BConstantes.P06B_PROPERTIES_DEFAULT);
			lstrValor = p1.getProperty(astrClave);
		} catch (IOException e) {
			// TODO Auto-generated catch block
            P06BLog.send(0,"P06BParametros", "_________ IOException  " + e.getMessage());
			e.printStackTrace();
			
		}
    	
    	return lstrValor;
        
        
    }
    
    /**
     *  Obtiene la caracterstica astrClave del fichero de propiedades Listados.
     *  @param  astrClave   caracterstica que queremos obtener.
     *  @return String      valor que tiene la caracterstica buscada.
     */    
    public static String getListado(String astrClave) {
        String lstrValor = "";
            
        P06BParametros utiles = new P06BParametros();
    	Properties p1;
		try {
			p1 = utiles.getParametros(P06BConstantes.P06B_PROPERTIES_LISTADOS);
			lstrValor = p1.getProperty(astrClave);
		} catch (IOException e) {
			// TODO Auto-generated catch block
            P06BLog.send(0,"P06BParametros : getListado", "_________ IOException  " + e.getMessage());
			e.printStackTrace();
		}
    	return lstrValor;
    }
    
    
}
